package edu.uky.ai.lp.logic;

/**
 * Represents a place-holder term which can be bound to any constant.
 * 
 * @author Stephen G. Ware
 */
public class Variable extends Term {
	
	/**
	 * Constructs a new variable with a given name.
	 * 
	 * @param name the name
	 */
	public Variable(String name) {
		super(name);
	}
	
	@Override
	public Unifier unify(Formula other, Unifier unifier) {
		if(other instanceof Term)
			return unifier.set(this, (Term) other);
		else
			return null;
	}

	@Override
	public Term substitute(Unifier unifier) {
		return unifier.get(this);
	}
}
